function membraneSegmentationGUI(objMembraneGP, objMembraneThresh, objProps)
close all

% For figure sizing
screenDim = get(0,'screensize');
screenDim(screenDim == 1) = [];
figWidth = floor((screenDim(1)-150)/3);

% Image set preview
g.f = figure('toolbar','none','menu','none','units','pixels',...
    'name','Select image with arrow keys. Draw ROI containing pixels to remove.');
imdisp(objMembraneGP,'Size',1);
set(g.f, 'position',[0,0,figWidth,figWidth])
movegui(g.f,'center')

% Set appdata
imgsRemoved = [];
setappdata(g.f,'imgsRemoved',imgsRemoved)
setappdata(g.f,'objMembraneGP',objMembraneGP)
setappdata(g.f,'objMembraneThresh',objMembraneThresh)
setappdata(g.f,'objProps',objProps)

% Preview montage
hh.f = figure('toolbar','none','menu','none','units','pixels', 'name','Preview: montage');
imdisp(objMembraneGP);
set(hh.f, 'position',[0,0,figWidth,figWidth])
movegui(hh.f,'east')

% Create figure
h.f = figure('toolbar','none','menu','none','units','pixels',...
    'position',[0,0,550,480], 'name','Spectral Imaging Tool - Segmentation Verifier');
movegui(h.f,'west')

% Introduction
h.t(1) = uicontrol('style','text','units','pixels',...
    'position',[15,260,530,200], 'HorizontalAlignment','Left');
intro = sprintf('The Spectral Imaging Toolbox segments membranes from the segmented objects automatically. The Membrane Segmentation GUI is used to verify this automatic membrane segmentation and to remove failed segmentation attempts as necessary.\nThe overview panel (right window) displays a gallery of the segmented membranes. The current image is shown in the center panel. Change the current image using the left and right arrows on the keyboard. Use this input GUI panel to remove the current image from the analysis if necessary.\nTo remove the current image from the analysis click remove current image. The image will be removed and this change will be reflected in the overview panel.\nWhen satisfied, click submit to continue analysis of the segmented membranes shown in the overview panel.');
set(h.t(1),'String',intro)

h.p(1) = uicontrol('style','pushbutton','units','pixels',...
    'position',[50,225,130,20],'string','Remove current image', 'callback',@p_removeImage);

h.p(2) = uicontrol('style','pushbutton','units','pixels',...
    'position',[50,25,130,20],'string','Submit', 'callback',@p_submit);

function p_removeImage(varargin)     
    % Get current state
    objMembraneGP = getappdata(g.f,'objMembraneGP');
    objMembraneThresh = getappdata(g.f,'objMembraneThresh');
    objProps = getappdata(g.f,'objProps');
    imgsRemoved = getappdata(g.f,'imgsRemoved');
    imData = get(g.f, 'UserData');
    if ~isempty(imData)
        imgInd = imData.index;
    else
        imgInd = 1;
    end
    
    % Remove images
    objMembraneGP(imgInd) = []; % remove poor image
    objMembraneGP = objMembraneGP(~cellfun(@isempty, objMembraneGP));
    objMembraneThresh(imgInd) = []; % remove poor image
    objMembraneThresh = objMembraneThresh(~cellfun(@isempty, objMembraneThresh));
    objProps(imgInd) = []; % remove poor image
    objProps = objProps(~cellfun(@isempty, objProps));

    % Keep record of indeces of images removed
    imgsRemoved = [imgsRemoved imgInd];
    
    % Update selection window 
    figure(g.f)
    clf(g.f)
    imdisp(objMembraneGP, 'Size',1);
    set(g.f, 'position',[0,0,figWidth,figWidth])
    movegui(g.f,'center')
    
    % Update preview montage
    figure(hh.f)
    clf(hh.f)
    imdisp(objMembraneGP);
    set(hh.f, 'position',[0,0,figWidth,figWidth])
    movegui(hh.f,'east')

    % Store results 
    setappdata(g.f, 'objMembraneGP', objMembraneGP) 
    setappdata(g.f, 'objMembraneThresh', objMembraneThresh) 
    setappdata(g.f,'objProps', objProps)
    setappdata(g.f, 'imgInd', imgInd)
    setappdata(g.f, 'imgsRemoved', imgsRemoved)   
end

function p_submit(varargin)
    % Get segmented images
    objMembraneGP = getappdata(g.f,'objMembraneGP');
    objMembraneThresh = getappdata(g.f,'objMembraneThresh');
    objProps = getappdata(g.f,'objProps');
    imgsRemoved = getappdata(g.f,'imgsRemoved');

    % Assign results to workspace
    assignin('base','objMembraneGP',objMembraneGP)
    assignin('base','objMembraneThresh',objMembraneThresh)
    assignin('base','objProps',objProps)
    assignin('base','imgsRemoved',imgsRemoved)
    close all
end
end
